var express = require('express');
const path = require('path');
const cookieParser = require('cookie-parser');
const logger = require('morgan');
const expressEjsLayouts = require('express-ejs-layouts');
const app = express();
const port = 5555;
const session = require('express-session');
const VacationController = require('./controllers/vacationController');
const cron = require('node-cron');
const tools = require('./functions/tools');
require('dotenv').config();

//  EXECUTER A 6H 30 CHAQUE JOUR
cron.schedule('30 6 * * *', () => {        
    //  DEPART EN CONGE
    VacationController.dateDepartVacation();
});

tools.changeMonth();


//  CONSTANTE
const PORT = process.env.PORT;
const SERVER = process.env.ENV === 'prod' ? process.env.SERVER : process.env.LOCAL;

// DECLARATION SESSION
app.use(session({
    name: process.env.SESS_NAME,
    secret: process.env.SECRET,
    resave: false,
    saveUninitialized: false,
    cookie: { 
        secure: false,
        maxAge: parseInt(process.env.ONEDAY),
        sameSite: true
    }
}));

//  OUTILS
app.use(logger('dev'));
app.use(express.json());
app.use(express.urlencoded({ extended: false }));
app.use(cookieParser());
app.use(express.static(path.join(__dirname, 'public')));
app.set('view engine','ejs');

//  EJS
app.use(expressEjsLayouts);
app.set('layout', './layouts/index');
app.set('view engine', 'ejs');

//  IMPORTATION DES ROUTES
var dashRoute = require('./routes/dashRoute');
var employeeRoute = require('./routes/employeeRoute');
var departmentRoute = require('./routes/departmentRoute');
var functionRoute = require('./routes/functionRoute');
var settingRoute = require('./routes/settingRoute');
var vacationRoute = require('./routes/vacationRoute');
var adminRoute = require('./routes/adminRoute');
var permissionRoute = require('./routes/permissionRoute');
var medicalLeaveRoute = require('./routes/medicalLeaveRoute');


//  LES ROUTES
app.use('/', dashRoute);
app.use('/employee', employeeRoute);
app.use('/function', functionRoute);
app.use('/department', departmentRoute);
app.use('/setting', settingRoute);
app.use('/vacation', vacationRoute);
app.use('/admin', adminRoute);
app.use('/permission', permissionRoute);
app.use('/medical', medicalLeaveRoute);


//  SERVER
if ( process.env.ENV == 'dev' ) {
    app.listen(PORT, SERVER,() => console.log(`Server on port ${PORT}  visiter:http://${SERVER}:${PORT}`));
}
else {
   //app.listen();
//server.listen(port, hostname, () => {
// console.log(`Server running at http://${hostname}:${port}/`);
app.listen(port, SERVER, ()=> { 
 console.log('Example app listening on port 5555 !'); 
}); 

}
