const { validationResult } = require("express-validator");
const db = require('../models');

const departmentModel = db.department;

//  ENREGISTRER UN DEPARTEMENT
 const save = async (req, res) => {
    const errors = validationResult(req);
  
    if (!errors.isEmpty()) {
      // Si des erreurs de validation existent, réaffichez le formulaire avec les erreurs
      // console.log(errors);
      return res.render('pages/forms/department.ejs', { errors: errors.array() });
    }
  
    // Si les données sont valides, traitez-les et redirigez l'utilisateur vers une autre page
    let depInfo = {
        nameDepartment: req.body.nomDepartement,
        descriptionDepartment: req.body.description
    };
    let departement = await departmentModel.create(depInfo);
    res.status(200).send(departement);
  }

//  TROUVER TOUS LES DEPARTEMENTS
  const findAll = async () => {
    return await departmentModel.findAll();
  }
module.exports = {
    save,
    findAll
}