const db = require('../models');
const cvModel = db.cv;

const getAllCv = async () => {
    return await cvModel.findAll();
}

const getCvByEmployeeId = (employeeId) => {
    return cvModel.findOne({
        where: {
            employeeId: employeeId
        },
        order: [['createdAt', 'DESC']]
    });
}

const getPhotoByEmployeeId = async (employeeId) => {
    return await db.photo.findOne({
        where: {
            employeeId: employeeId
        },
        order: [['createdAt', 'DESC']]
    });
}

const getPassingFile = async ( passingFileId ) => {
    return await db.passingFile.findOne({
        where: { id: passingFileId }
    })
} 


module.exports = {
    getAllCv,
    getCvByEmployeeId,
    getPhotoByEmployeeId,
    getPassingFile
};
