const { validationResult } = require('express-validator');
const db = require('../models');

// const EmployeeModel = db.employee;
// const CongeeModel = db.congee;
const functionModel = db.function;


//  Valider et enregistrer les informations 
const save = async (req, res) => {
    const errors = validationResult(req);
  
    if (!errors.isEmpty()) {
      const departments = await departementController.findAll();

      // Si des erreurs de validation existent, réaffichez le formulaire avec les erreurs      
      return res.render('pages/forms/function.ejs', { departments ,errors, req });      
    }  
  
    // Si les données sont valides, traitez-les et redirigez l'utilisateur vers une autre page    
    let infoFunction = {
      nameFunction: req.body.nomFonction,
      category: req.body.categorie,
      baseSalary: req.body.salaireBase,
      departmentId: req.body.departement == '0' ? null : req.body.departement
    };

    //  Le nom de la fonction est unique, verifier s'il existe deja
    let verify = await functionModel.findOne({ where: { nameFunction: infoFunction.nameFunction }});
    if(verify) {
      return res.redirect('/function/newFunct');
    }

    let functionSaved = await functionModel.create( infoFunction );
    res.redirect('/function/newFunct');
};


//  TROUVER TOUTES LES FONCTIONS 
const findAll = async (req, res ) => {
    return await functionModel.findAll();
};

//  TROUVER LA FONCTION D'UN EMPLOYEE
const getFunctionEmployee = async ( employeeId ) => {
  let employee = await db.employee.findOne({ where: { id: employeeId }});
  //  Leur fonction      
  if(employee) {        
    var employeeFunct = await db.employeeFunction.findOne({
      where: { employeeId: employee.id },
      order: [['date', 'DESC'],['createdAt','DESC']]
    });
    if (employeeFunct) {
      let fonction = await db.function.findOne({
        where: { id: employeeFunct.functionId }
      });
      return fonction;          
    }    
  }
  return null;      
}

module.exports = {
    save,
    findAll,
    getFunctionEmployee
}
