const moment = require('moment');
const DB = require('../models/index');
const functionController = require('./functionController');
const { Op } = require('sequelize');

const getMedicalOnYear = async (employeeId, currentDate) => {
    const YEAR = moment(currentDate).year();

    //  Verify employee
    let employee = await DB.employee.findByPk(employeeId);
    if(!employee) {
        return 0;
    }

    let nbrMedical = 0;
    // All permission of employee
    let medicals = await DB.medical.findAll({
        where: {
            employeeId: employeeId,
        }
    });

    //  Permissing of YEAR
    medicals.forEach(medical => {
        let year = moment(medical.startDate).year();
        if(year == YEAR) {
            nbrMedical += medical.nbrDays;
        }
    });
    return nbrMedical;
}

/**
 * Demander un repos medical
 * @param {request} req 
 * @param {response} res
 * @returns 
 */
const requestMedical = async (req, res) => {
    let { demandeur, sick, start, end, id, interimId, interimaire } = req.body;    

    //  VERIFIER QUE CE SONT DES FUTURES DATES
    let n = nbrDaysBetweenDates(moment(), start);    

    // Date de debut plus tot qu'aujourdhui et moin d'une semaine
    //  Seul le super admin peut demander un conge avec la date de depart est moins d'une semaine  
    if( req.session && req.session.admin && req.session.admin.role !== 'Super admin') {
        if(n <= 0 ) {    
            let msg = "Date de début non valide.";
            return returnRequestMedical(msg, req, res)
        }
        if( n < 7) {
            let msg = "Date de début non valide.";
            return returnRequestMedical(msg, req, res)
        }
    }

    //  DATE LOGIQUE start <= end
    let nbrDays = nbrDaysBetweenDates(moment(start), moment(end)) + 1;
    //  Si le start est plus tard que end
    if( nbrDays < 0 ) {
        tmp = start;
        start = end;
        end = tmp;
    }

  //  VERIFIER QUE C'EST UN VRAI EMPLOYEE    
  if(id !== '') {    
    let employee = await DB.employee.findOne({ where: { id: id}});
    if(!employee) {      
      let msg = "Utilisateur introuvable.";
      return returnRequestMedical(msg, req, res);      
    }    

    //  ROLE DE EMPLOYEE S'IL A UN ROLE
    let roleEmployee = await DB.admin.findOne({ where: { matriculeEmployee: employee.matricule }});
    if(!roleEmployee) {      
      roleEmployee = '';      
    }

    // TROUVER LE DEMANDEUR
    let applicant = await DB.admin.findOne({ where: { id: demandeur }});
    if(!applicant) {      
      let msg = "Demandeur introuvable.";
      return returnRequestVacation(msg, req, res);
    }

    //  ENREGISTRER le repos OU LA DEMANDE    
    let medical = await DB.medical.create({
      nbrDays: nbrDays,
      sick: sick,
      startDate: moment(start),
      endDate: moment(end),
      AdmnistratorId: null,
      interimId: interimId,      
      applicantId: applicant.id,
      employeeId: id
    });

    //  PIECE JUSTIFICATIF
    if(req.file) {        
        const { fieldname, filename, path, mimetype } = req.file;        
        let r = await DB.medicalJustificative.create({
            filename,
            path,
            mimetype,
            medicalId: medical.id
        });        
    }
    
  
    //  ENVOYER LE MAIL VERS LEUR SUPERIEUR DE L'EMPLOYEE
    //  Fonction de l'employee
    let fonction = await functionController.getFunctionEmployee(employee.id);    
    employee.fonction = fonction ? fonction.nameFunction : '';    

    //  Validateurs à envoyer le mail de notifications
    let idValidators = await DB.adminEmployee.findAll({ where: {
      [Op.and]: [
        { isValidator: true },
        { employeeId: employee.id }
      ]
    }});

    let allAdmin = [];
    for(let i = 0; i < idValidators.length; i++) {
      let admin = await DB.admin.findOne({ where:{ id: idValidators[i].AdmnistratorId}});
      if(admin) {
        allAdmin.push(admin);
      }
    }    
    var mails = [];
    allAdmin.forEach(function(admin) {
      mails.push(admin.email);
    })        

    let emailsToSend = [];
    for( i = 0; i < mails.length; i++ ) {
      let email = mails[i];      
      if( email !== applicant.email ) {
        let mail = {};
        mail.recipient = email;
        mail.subject = 'Demande de validation de repos maladie';
        mail.message = 
        `Bonjour, 
${employee.name_employee} ${employee.last_name_employee}
matricule:${employee.matricule}
Fonction: ${employee.fonction}
Veuillez-vous connecter sur le site ${process.env.SITE}`;        
        
        emailsToSend.push(mail);        
      }
  
    }
    sendAllMails(emailsToSend);
    if(interimaire !== '') {

      let data = {
        poste: employee.fonction,
        direction: req.body.direction,
        holder: employee.name_employee + ' ' + employee.last_name_employee,
        interim: interimaire,
        medicalId: medical.id,
        permissionId: null,
        vacationId: null,
      }
  
      // Passation de service
      try {
          var passFile = await DB.passingFile.create(data);
      }
      catch(err) {
          console.log(err);
          return res.send(err);
      }
  
      //  Tache
      let task = req.body.taches;
      let deliverable = req.body.livrables;
      let reference = req.body.referentiels;
  
      if(task && deliverable && reference) {
            //  S'il y a plusieurs (tableau)            
          if( Array.isArray(task) && Array.isArray(deliverable) && Array.isArray(reference) ) {
              for(let i = 0; i < task.length && i < deliverable.length && i < reference.length; i++) {                    
                  if(task[i] && deliverable[i] && reference[i]) {
                      let rslt = await DB.task.create({
                          description : task[i], 
                          deliverable : deliverable[i],
                          reference : reference[i],
                          passingFileId: passFile.id                
                      });
                  }
              }
          }
          else {                
              let rslt = await DB.task.create({
                  description : task, 
                  deliverable, 
                  reference,
                  passingFileId: passFile.id
              });                
          }
      }
  
      //  Personnel
      let noms = req.body.noms;
      let fonctions = req.body.fonctions;
  
      if(noms && fonctions) {            
          if( Array.isArray(noms) && Array.isArray(fonctions) ) {
              for(let i = 0; i < noms.length && i < fonctions.length ; i++) {
                  if(noms[i] && fonctions[i]) {
                      let rslt = await DB.personnel.create({
                          name_and_last: noms[i],
                          fonction: fonctions[i],
                          passingFileId: passFile.id                
                      });
                  }
              }
          }
          else {                
              let rslt = await DB.personnel.create({
                  name_and_last: noms,
                  fonction: fonctions,
                  passingFileId: passFile.id
              });                
          }
      }
  
      //  Materiels
      let description = req.body.descriptions;
      let quantity = req.body.quantities;
      let state = req.body.etats;      
  
      if(description && quantity && state) {            
          if( Array.isArray(description) && Array.isArray(quantity) && Array.isArray(state)) {
              for(let i = 0; i < description.length && i < quantity.length && i < state.length; i++) {
                  if(description[i] && quantity[i] && state[i]) {
                      let rslt = await DB.material.create({
                          description: description[i],
                          quantity: quantity[i],
                          state: state[i],
                          passingFileId: passFile.id                
                      });
                  }
              }
          }
          else {                
            let rslt = await DB.material.create({
              description: description,
              quantity: quantity,
              state: state,
              passingFileId: passFile.id
            });                
          }
      }
  
      // Signatures
      let doc_type = req.body.typeDocs;
      let responsability_level = req.body.responsabilites;
  
      if(doc_type && responsability_level) {            
          if( Array.isArray(doc_type) && Array.isArray(responsability_level) ) {
              for(let i = 0; i < doc_type.length && i < responsability_level.length ; i++) {
                  if(doc_type[i] && responsability_level[i]) {
                      let rslt = await DB.signature.create({
                          doc_type: doc_type[i],
                          responsability_level: responsability_level[i],
                          passingFileId: passFile.id                
                      });
                  }
              }
          }
          else {                
              let rslt = await DB.signature.create({
                  doc_type: doc_type,
                  responsability_level: responsability_level,
                  passingFileId: passFile.id                                    
              });                
          }
      }    
    }

    return res.redirect(`/medical/${medical.id}`);
  }
  else {    
    let msg = "Veuillez choisir un employé";
    return returnRequestMedical(msg, req, res);
  }
}

const returnRequestMedical = async (msg, req, res) => {
    //  Id de l'employee 
    const id = req.params.id || null;
    let errors = [{
        msg: msg
    }];
    let employees = [];
    
    //  Pour le simple demande
    if (!id) {    
        //  Trouver tout les employees
        var allEmployee = await DB.employee.findAll();  
        for(let i = 0; i < allEmployee.length; i++) {
            allEmployee[i].interims = [];
            if(allEmployee[i]) {
                let interims = await DB.interim.findAll({ where:{ employeeId: allEmployee[i].id }});
                for(let j = 0; j < interims.length; j++) {
                    let interim = await DB.employee.findOne({ where: { id: interims[j].interimId}});
                    if(interim) {
                        allEmployee[i].interims.push(interim)
                    }
                }
            }       
        }      
        console.log(allEmployee[0].interims)
    }
    //  Pour le demande personnaliser d'un employee
    else {
        var allEmployee = [];
        result = await DB.employee.findOne({ where: { id: id }});
        //  Leur interimaire
        if(result) {
            result.interims = [];
            let interims = await DB.interim.findAll({ where:{ employeeId: result.id }});
            for(let j = 0; j < interims.length; j++) {
                let interim = await DB.employee.findOne({ where: { id: interims[j].interimId}});
                if(interim) {
                    result.interims.push(interim)
                }
            }            
            allEmployee.push(result);
        }
    }
    //  Trouver leurs medical de l'annee
    for( i = 0; i < allEmployee.length; i++ ) {        
        
        let canApplicant = await DB.adminEmployee.findOne({where : {
            [Op.and]: [
                { isApplicant: true },
                { employeeId: allEmployee[i].id },
                { AdmnistratorId: req.session.admin.id }
            ]
        }})
        
        if( canApplicant ) {            
            let employee = allEmployee[i];
            employee.medical = await getMedicalOnYear(1, new moment());
            let fonction = await FunctionController.getFunctionEmployee(employee.id);
            if(fonction) {
                employee.fonction = fonction.nameFunction;
            }
            else {
                employee.fonction = '';
            }            
            employees.push(employee);
        }                
    }                   
    res.render('pages/forms/medical.ejs', { employees, errors, req });
}

const update = async (req, res) => {
    let id = req.params.id || null;
    let { idEmployee, valid, validator = null } = req.body;    

    if( id && idEmployee !== '' ) {                    
        if(validator && valid == 'on' ) {      
            let admin = await DB.admin.findOne({ where: { id: validator }})
            if(admin) {        
                //  repos maladie valider        
                await DB.medical.update(
                    { AdmnistratorId: (valid == 'on') ? admin.id : null },
                    { where: {id: id }}
                );
                
                //  Envoyer mail vers demandeur que le conge est valider
                //  Trouver le demandeur et l'employee  
                let medical = await DB.medical.findByPk(id);
                let applicant = await DB.admin.findOne({ where: {id : medical.applicantId }});
                let employee = await DB.employee.findOne({ where: { id: medical.employeeId }})
                if(applicant) {
                    let email = applicant.email;
                    const MAIL = process.env.ENV == 'prod' ? process.env.MAIL : process.env.MAIL_LOCAL;
                    
                    //  Trouver le validateur
                    let validateur = await DB.admin.findOne({ where: { id: medical.AdmnistratorId }});
                    if(validateur) {                                
                    const mailOptions = {          
                        from: MAIL,
                        to: email,
                        subject: 'Validation de repos maladie',
                        text: 
                        `${employee.name_employee} ${employee.last_name_employee}
                        matricule:${employee.matricule}
                        repos maladie validée par ${validateur.firstName} ${validateur.lastName}
                        Veuillez-vous connecter sur le site ${process.env.SITE} pour voir le détail`          
                    };        
                    console.log(email)                        
                    }
                }
            }                  
        } 
    }
    else {    
        msg = "Veuillez choisir un employé"    
        return returnRequestMedical(msg, req, res);
    }      
    res.redirect(`/`);
}

const nbrDaysBetweenDates = (startDate, endDate = moment() ) => {
    var nbrDays = moment(endDate).diff(moment(startDate), 'days');
    return nbrDays;
}

const waitingMedical = async (req) => {
    let medicals = await DB.medical.findAll({
        where: { AdmnistratorId: null }
      });
      
    let data = [];
    for( i = 0; i < medicals.length; i++) {      
        let employee = await DB.employee.findOne({ where: { id: medicals[i].employeeId }});
        let canValidate = await DB.adminEmployee.findOne({ where: {
          [Op.and]: [
            { isValidator: true },
            { employeeId: employee.id },
            { AdmnistratorId: req.session.admin.id }
          ]
        }});    
        //  Leur fonction
        if(employee && canValidate && medicals[i]) {          
          employee.fonction = await functionController.getFunctionEmployee(employee.id);
          employee.medical = medicals[i];
          //  Trouver le demandeur
          let applicant = await DB.admin.findOne({ where: { id: employee.medical.applicantId }});
          if(applicant) {
            employee.medical.applicant = applicant;
          }          
          data.push(employee);
        }            
    }
    return data;
}

// conge prochain
const nextMedical = async ( req, nowDate ) => {
  let now = nowDate;
  let medicals = await DB.medical.findAll({
    where: {
      [Op.and]: [
        { startDate: { [Op.not]: null }}, // startDate is not null       
        { startDate: { [Op.gt]: now }}, //  startDate > now
        { AdmnistratorId: { [Op.not]: null }},
        { AdmnistratorId: { [Op.gt]: 0 }}, // Valeur > 0
      ]
    }
  });

  let data = [];
  for( let i = 0; i < medicals.length; i++) {
    let nbrDays = nbrDaysBetweenDates( now, medicals[i].startDate );    
    if(nbrDays <= 30 && nbrDays > 0 ) {
      
      let employee = await DB.employee.findOne({ where: { id: medicals[i].employeeId }});
      //  Leur fonction
      if(employee) {        
        employee.fonction = await functionController.getFunctionEmployee(employee.id);
        employee.medical = medicals[i];
        //  Trouver le validateur
        if(employee.medical) {
          var validateur = await DB.admin.findOne({ where: { id: employee.medical.AdmnistratorId }});
          if(validateur) {                    
            employee.medical.validateur = validateur;
          }        
        }        
        
        employee.nbrDaysBefor = nbrDaysBetweenDates(now, medicals[i].startDate);
        let canApplicant = await DB.adminEmployee.findOne({where: {
          [Op.and]: [
            { isApplicant: true },
            { employeeId: employee.id },
            { AdmnistratorId: req.session.admin.id }
          ]
        }});
        if(canApplicant) {
          data.push(employee);
        }
      }            
    }
  };  
  return data;
}

const currentMedical = async ( nowDate ) => {
    let now = nowDate;
    //  Congee en cours
    let currents = await DB.medical.findAll({
      where : {
        [Op.and]: [
          { startDate: { [Op.lte]: now }}, // startDate <= now
          { startDate: { [Op.not]: null }}, // startDate is not null
          { endDate: { [Op.gte]: now }}, // endDate >= now
          { AdmnistratorId: { [Op.not]: null }},
          { AdmnistratorId: { [Op.gt]: 0 }},
        ]      
      }
    });
    var data = []
    if(currents) {    
      //  Trouver l'employe en permission
      for(i = 0; i < currents.length; i++ ) {      
        let employee = await DB.employee.findOne({ where: { id: currents[i].employeeId }});
        //  Leur fonction      
        if(employee) {        
          var employeeFunct = await DB.employeeFunction.findOne({
            where: { employeeId: employee.id },
            order: [['date', 'DESC']]
          });
          if (employeeFunct) {
              let fonction = await DB.function.findOne({
                  where: { id: employeeFunct.functionId }
              });
              if(fonction)
              employee.fonction = fonction;          
          }
          employee.medical = currents[i];
          //  Trouver le validateur
          let validateur = await DB.admin.findOne({ where: { id: employee.medical.AdmnistratorId }});
          if(validateur) {                    
            employee.medical.validateur = validateur;
          }        
  
          employee.restDay = nbrDaysBetweenDates(now, employee.medical.endDate) + 1;        
          data.push(employee);        
        }      
      }
    }        
    return data;
  }

  const rejectedMedical = async () => {
    let now = new Date();
    let rejectedMeds = await DB.medicalRejected.findAll({
      where: {              
        rejectedBy : {[Op.not]: null }
      }
    });
    let data = [];
    for( i = 0; i < rejectedMeds.length; i++) {
      let nbrDays = nbrDaysBetweenDates( rejectedMeds[i].createdAt, now );    
      if(nbrDays < 1) {        
        let employee = await DB.employee.findOne({ where: { id: rejectedMeds[i].employeeId }});
        //  Leur fonction
        if(employee) {        
          employee.fonction = await functionController.getFunctionEmployee(employee.id);      
          employee.rejectedVac = rejectedMeds[i];            
          //  Trouver le rejecteur
          let rejector = await DB.admin.findOne({ where: { id: rejectedMeds[i].rejectedBy }});
          if(rejector) {                    
            employee.rejector = rejector;
          }                
          data.push(employee);
        }            
      }      
      setTimeout(async () => await rejectedMeds[i].destroy(), 10*60*1000);
    };  
    return data;
  }

/**
 * Envoyer plusieurs mails
 * @param { Array } emailsToSend
 */
const sendAllMails = (emailsToSend) => {
  for(let i = 0; i < emailsToSend.length; i++) {
    sendEmail(emailsToSend[i]);
  }  
}

  /**
 * Fonction qui envoie un mail 
 * @param { object } emailDetails
 */
const sendEmail = (emailDetails) => {  
  const MAIL = process.env.ENV == 'prod' ? process.env.MAIL : process.env.MAIL_LOCAL;
  
  const mailOptions = {
    from: MAIL,
    to: emailDetails.recipient,
    subject: emailDetails.subject,
    text: emailDetails.message,
  };

  if(process.env.ENV == 'prod') {
    transporter.sendMail(mailOptions, (error, info) => {
      if (error) {
        console.error('Error sending email:', error);
      } else {
        console.log('Email sent:', info.response);
      }
    });
  }
  else {
    console.log(mailOptions);
  }
};

module.exports = {
    getMedicalOnYear,
    requestMedical,
    nbrDaysBetweenDates,
    update,
    waitingMedical,
    nextMedical,
    currentMedical,
    rejectedMedical,
}