const entities = require('./entities');
require('dotenv').config()

const { Sequelize , DataTypes } = require('sequelize');

const database = process.env.ENV == 'prod' ? process.env.DATABASE : process.env.DATABASE_LOC;
const user = process.env.ENV == 'prod' ? process.env.USER : process.env.USER_LOC;
const pass = process.env.ENV == 'prod' ? process.env.PASSWORD : null;
const host = process.env.HOST;
const dialect = process.env.DIALECT;

// instanciation de sequelize 
const sequelize = new Sequelize(
    database,
    user,
    pass,    
    {
        host : host,
        dialect : dialect
    }
);

//  authentification a la base de donnees
sequelize.authenticate()
.then(() => {
    console.log('Connected...')
})
.catch((err) => console.log('ERREUR: ' + err));

// Initialisation de l'objet database
const db = {};

db.sequelize = sequelize;
// db.Sequelize = Sequelize;

// Modeles et les tables de la base de donnees
db.entities = entities(sequelize, DataTypes);

db.admin = db.entities.Admin;
db.token = db.entities.Token;
db.employee = db.entities.Employee;
db.function = db.entities.Function;
db.employeeFunction = db.entities.EmployeeFunction;
db.vacation = db.entities.Vacation;
db.department = db.entities.Department;
db.childEmployee = db.entities.ChildEmployee;
db.variable = db.entities.Variable;
db.cv = db.entities.Cv;
db.vacationRejected = db.entities.vacationRejected;
db.adminEmployee = db.entities.adminEmployee;
db.photo = db.entities.Photo;
db.interim = db.entities.Interim;
db.passingFile = db.entities.PassingFile;
db.task = db.entities.Task;
db.personnel = db.entities.Personnel;
db.material = db.entities.Material;
db.signature = db.entities.Signature;
db.permission = db.entities.Permission;
db.permissionJustificative = db.entities.PermissionJustificative;
db.permissionRejected = db.entities.PermissionRejected;
db.medical = db.entities.Medical;
db.medicalJustificative = db.entities.MedicalJustificative;
db.medicalRejected = db.entities.MedicalRejected;
db.planning = db.entities.Planning;
db.holiday = db.entities.Holiday;

// db.sequelize.sync({ force : false })
// .then(() => {
//     console.log('synchronisee...')
// })

// exporter l'objer database
module.exports = db;