const express = require('express');
const router = express.Router();
const authentification = require('../middlewares/authentification');
const VacationController = require('../controllers/vacationController');
const PermissionController = require('../controllers/permissionController');
const MedicalController = require('../controllers/medicalController');
const DB = require('../models/index');
const { Op } = require('sequelize');

//  ROUTES GLOBALS
router.get('/', authentification,(req, res) => {
    res.redirect('home');
})

router.use('/home', authentification,async (req, res) => {           
    let currentVac = await VacationController.currentVacationAndEmployee(new Date());     
    let nextVac = await VacationController.nextVacationAndEmployee(req, new Date());  
    let alertVac = await VacationController.alertVacationAndEmployee(req ,new Date()); 
    let waitingVac = await VacationController.waitingVacAndEmployee(req);
    let rejectedVac = await VacationController.rejectedVacAndEmployee(new Date());
    
    let waitingPermiss = await PermissionController.waitingPermiss(req);
    let nextPermiss = await PermissionController.nextPermission(req, new Date());
    let currentPermiss = await PermissionController.currentPermission(new Date());
    let rejectedPermiss = await PermissionController.rejectedPermission(new Date());

    let waitingMedical = await MedicalController.waitingMedical(req);
    let nextMedical = await MedicalController.nextMedical(req, new Date());
    let currentMedical = await MedicalController.currentMedical(new Date());
    let rejectedMedical = await MedicalController.rejectedMedical(new Date());

    let nbrCurrentVac = currentVac.length;
    let nbrCurrentPermiss = currentPermiss.length;
    let nbrCurrentMed = currentMedical.length;
    
    let nbrNextVac = nextVac.length + nextPermiss.length + nextMedical.length;    
    let nbrAlertVac = alertVac.length;
    let nbrWaiting = waitingVac.length + waitingPermiss.length + waitingMedical.length;
    let nbrRejected = rejectedVac.length + rejectedPermiss.length + rejectedMedical.length;
    res.render('home', {                 
        req, nbrCurrentMed, nbrCurrentVac, nbrCurrentPermiss, nbrNextVac, nbrAlertVac, nbrWaiting, nbrRejected
    });
})

router.get('/currentVac', authentification, async (req,res) => {
    let currentVac = await VacationController.currentVacationAndEmployee(new Date());        
    res.render('pages/admin/currentVac',{ currentVac, req })
})

router.get('/currentPermiss', authentification, async (req,res) => {
    let currentPermis = await PermissionController.currentPermission(new Date());    
    res.render('pages/admin/currentPermis',{ currentPermis, req })
})

router.get('/currentMedical', authentification, async (req,res) => {
    let currentMedical = await MedicalController.currentMedical(new Date());    
    res.render('pages/admin/currentMedical',{ currentMedical, req })
})

router.get('/next', authentification, async (req,res) => {
    let nextVac = await VacationController.nextVacationAndEmployee(req, new Date()); 
    let nextPermiss = await PermissionController.nextPermission(req, new Date());    
    let nextMed = await MedicalController.nextMedical(req, new Date());
    res.render('pages/admin/next',{ nextVac, nextPermiss, nextMed, req })
})

router.get('/alert', authentification, async (req,res) => {
    let alertVac = await VacationController.alertVacationAndEmployee(req ,new Date());
    res.render('pages/admin/alert',{ alertVac, req })
})

router.get('/wait', authentification, async (req,res) => {
    let waitingVac = await VacationController.waitingVacAndEmployee(req);    
    let waitingPermiss = await PermissionController.waitingPermiss(req);
    let waitingMedical = await MedicalController.waitingMedical(req);
    res.render('pages/admin/waiting',{ waitingVac, waitingPermiss, waitingMedical, req });
})

router.get('/reject', authentification, async (req,res) => {
    let rejectedVac = await VacationController.rejectedVacAndEmployee(new Date());
    let rejectedPermiss = await PermissionController.rejectedPermission(new Date());
    let rejectedMed = await MedicalController.rejectedMedical();
    rejectedVac = rejectedVac.concat(rejectedPermiss);
    rejectedVac = rejectedVac.concat(rejectedMed);    
    console.log(rejectedVac);    
    res.render('pages/admin/rejected',{ rejectedVac, req })
})

router.get('/historic', authentification, async (req, res) => {
    let historic = await VacationController.historicVacAndEmployee(req);
    res.render('pages/admin/historic',{ historic, req });
})

router.get('/procedure', authentification, (req, res) => {
    res.render('pages/files/procedure', { req });
})

router.get('/planning', authentification, async (req, res) => {    
    let errors = null;
    let employees = [];

    let timeToPlanning = false;
    let month = new Date().getMonth() + 1;

    if (month == 1 || month == 2 || month == 7 || month == 8) {
        timeToPlanning = true;
    }
    // if (moth == 1);

    //  Trouver tout les employees pour mettre les nouveaux plannings
    var allEmployee = await DB.employee.findAll();       
        
    for(let i = 0; i < allEmployee.length; i++ ) {        
        
        let canApplicant = await DB.adminEmployee.findOne({
            where: {
                [Op.and]: [
                    { isApplicant: true },
                    { employeeId: allEmployee[i].id },
                    { AdmnistratorId: req.session.admin.id }
                ]
            }
        });
        
        if(canApplicant ) {
            let employee = allEmployee[i];
            employees.push(employee);
        }                
    }
    
    //  Planning à afficher
    let plannings = await VacationController.findFuturePlanning(req);

    res.render('pages/admin/planning.ejs', {employees, plannings, timeToPlanning, errors, req });
})
module.exports = router