var express = require('express');
var { body } = require('express-validator');
var router = express.Router();
var departementController = require('../controllers/departmentController');
const authentification = require('../middlewares/authentification');

router.get('/newDep', authentification,( req, res, next ) => {       
    let errors = null;
    res.render('pages/forms/department.ejs', { errors, req });
});

router.post('/save',
    authentification,[
    body('nomDepartement').notEmpty().withMessage('Le nom du département est obligatoire'),
    body('description').optional().isLength({ max: 200 }).withMessage('La description doit contenir au maximum 200 caractères')
    ],
    departementController.save
);

  


  

module.exports = router;