var express = require('express');
var { body } = require('express-validator');
var functionController = require('../controllers/functionController');
var router = express.Router();
var departementController = require('../controllers/departmentController');
const authentification = require('../middlewares/authentification');

//  Envoie de formulaire d'ajout d'un département
router.get('/newFunct', 
  authentification,
  async ( req, res, next ) => {   
    errors = null;         
    // Récupérer les données des départements depuis la base de données
    const departments = await departementController.findAll();

    res.render('pages/forms/function.ejs', { departments ,errors, req });
});

//  Validation et enregistrement des informations
router.post('/save', 
    authentification,[
    body('nomFonction').notEmpty().withMessage('Le nom de la fonction est obligatoire'),
    // body('categorie').notEmpty().withMessage('La catégorie est obligatoire'),
    // body('salaireBase').notEmpty().withMessage('Le salaire de base est obligatoire'),
    // body('departement').notEmpty().withMessage('Le département est obligatoire')
  ], 
  functionController.save
);
  

module.exports = router;